using System;
using System.Drawing;
using System.Windows.Forms;
using System.ComponentModel;

namespace LicControlDemo
{
	// This is an example of how to create a licensed control in C#Builder.
	// A simple licensing solution uses the prebuilt LicFileLicenseProvider
	// class in your component to raise an exception if the user's development
	// platform doesn't find a valid license file.
	// Once you finish the design and deploy your licensed component the presence
	// of a license file in the developer's machine will garantee his/her ability
	// to use the component.
	// In this example I made the parent control abstract so that you have to
	// create a descendant of LicControl to be able to use it. This descendant
	// was named InheritedLicControl.
	//
	// Note that when installing the assembly you will only see the descendant in
	// the Tool Palette. The Tool Palette you not display abstract or internal
	// controls.
	//
	// Remember to place the LIC file in the same directory as the generated assembly.
	//
	// Implementing the licensing feature for the component requires three steps.
	//
	// 1) First, you must use an attribute to inform the compiler that you're
	// using the LicFileLicenseProvider licensing functionality.
	// Add this code just before the component class declaration.
	//
	// 2) Second, add a constructor to your component class in order to search
	// for a license file during the object instantiation. You use the static
	// Validate() method that the LicenseManager class provides to ask for a
	// License object.
	//
	// 3) The last step is to free memory resources that the objects you created
	// in the component class constructor consume. Override the Dispose() method.

	[LicenseProvider(typeof(LicFileLicenseProvider))]
	abstract public class LicControl: UserControl
	{
		private License m_lic;
		public System.Windows.Forms.Label label1;

		public LicControl()
		{
			m_lic = LicenseManager.Validate(typeof(LicControlDemo.LicControl), this);
			InitializeComponent();
		}

		protected override void Dispose(bool disposing)
		{
			if (m_lic != null)
			{
				m_lic.Dispose();
				m_lic = null;
			}
			base.Dispose(disposing);
		}

		abstract protected void SetLabel1Text();

		#region Component Designer generated code
		private void InitializeComponent()
		{
			this.label1 = new System.Windows.Forms.Label();
			this.SuspendLayout();
			// 
			// label1
			// 
			this.label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
			this.label1.ForeColor = System.Drawing.SystemColors.ActiveCaption;
			this.label1.Location = new System.Drawing.Point(16, 16);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(176, 40);
			this.label1.TabIndex = 0;
			this.label1.Text = "Licensed Control";
			// 
			// LicControl
			// 
			this.BackColor = System.Drawing.Color.FromArgb(((byte)(255)), ((byte)(192)), ((byte)(128)));
			this.Controls.Add(this.label1);
			this.Name = "LicControl";
			this.Size = new System.Drawing.Size(200, 72);
			this.ResumeLayout(false);
		}
		#endregion

	}
}
